package cz.drg.clasificator.readers;

import cz.drg.clasificator.setting.ProgramSettings;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.util.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import static cz.drg.clasificator.util.OutputHelper.*;
import java.util.zip.ZipFile;


public class SystemInReader extends BaseReader {
    
    static{loadDefaults();}
    
    private static String DEFAULT_CHARSET;
    private static String DEFAULT_DELIMITER;
    private static String DEFAULT_PMML_INPUT_FILEPATH;
    private static ZipFile DEFAULT_PMML_INPUT;
    
    private static Charset CHARSET;

    public SystemInReader(ZipFile pmmlInput, String delimiter, String charsetName) {
        super(pmmlInput, delimiter);
        
        try{
            CHARSET = Charset.forName(charsetName);
        }
        catch(UnsupportedCharsetException ex){
            dualLog(String.format(Constants.ERR_UNSUPPORTED_CHARSET_NAME, charsetName, DEFAULT_CHARSET));
            CHARSET = Charset.forName(DEFAULT_CHARSET);
        }
        
        init();
    }

    public SystemInReader(){
        this(DEFAULT_PMML_INPUT, DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }
    
    /**
     * Init class default values. This expects settings to be loaded before use.
     */
    private static void loadDefaults(){
        ProgramSettings programSettings = Settings.getProgramSettings();
        
        DEFAULT_PMML_INPUT_FILEPATH = programSettings.getDefaultPmmlPath();
        DEFAULT_CHARSET = programSettings.getDefaultCharset();
        DEFAULT_DELIMITER = programSettings.getDefaultDelimiter();
        
        try{
            DEFAULT_PMML_INPUT = new ZipFile(DEFAULT_PMML_INPUT_FILEPATH);
        } catch (IOException ex) {
            dualLog("Error loading default PMML zip file: '"+DEFAULT_PMML_INPUT_FILEPATH+"'");
            System.exit(-1);
        }
    }
    
    @Override
    protected List<String> getData() {
        
        List<String> lines = new ArrayList<>();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, CHARSET));
        String s;
        try {
            while ((s = in.readLine()) != null && s.length() != 0) {
                lines.add(s);
            }
        } catch (IOException ex) {
            Logger.getLogger(SystemInReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        return lines;
    }

    @Override
    public boolean hasNextEntryBatch() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    }
